<?php
// Konfigurasi database
$host = 'localhost';
$dbname = 'iotprojectweb_geofence_db';
$username = 'iotprojectweb_admin';
$password = '@Geofence';

// Membuat koneksi ke database
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    die("Koneksi gagal: " . $e->getMessage());
}

// Handle POST request untuk menyimpan data
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Mulai transaksi
        $pdo->beginTransaction();

        // Hapus semua data lama
        $stmtDelete = $pdo->prepare("DELETE FROM geofence");
        $stmtDelete->execute();

        // Ambil data dari request
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (!$data) {
            throw new Exception('Data tidak valid');
        }

        $latitude = floatval($data['latitude']);
        $longitude = floatval($data['longitude']);
        $radius = floatval($data['radius']);

        // Validasi data
        if (!is_numeric($latitude) || !is_numeric($longitude) || !is_numeric($radius)) {
            throw new Exception('Input harus berupa angka');
        }

        // Prepare statement untuk insert data baru
        $stmtInsert = $pdo->prepare("INSERT INTO geofence (latitude, longitude, radius, created_at) VALUES (?, ?, ?, NOW())");
        
        // Execute statement
        $stmtInsert->execute([$latitude, $longitude, $radius]);

        // Commit transaksi
        $pdo->commit();

        // Kirim response sukses
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'success', 
            'message' => 'Data berhasil diperbarui',
            'data' => [
                'latitude' => $latitude,
                'longitude' => $longitude,
                'radius' => $radius
            ]
        ]);

    } catch (Exception $e) {
        // Rollback jika terjadi error
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }
        
        // Handle error
        header('HTTP/1.1 400 Bad Request');
        header('Content-Type: application/json');
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

// Di file save_geofence.php, pastikan bagian GET handler seperti ini:

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $stmt = $pdo->query("SELECT * FROM geofence ORDER BY created_at DESC LIMIT 1");
        $data = $stmt->fetch();

        header('Content-Type: application/json');
        if ($data) {
            // Konversi nilai numerik
            $data['latitude'] = floatval($data['latitude']);
            $data['longitude'] = floatval($data['longitude']);
            $data['radius'] = floatval($data['radius']);
            
            echo json_encode([
                'status' => 'success',
                'data' => $data
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'data' => null
            ]);
        }
    } catch (Exception $e) {
        header('HTTP/1.1 400 Bad Request');
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error', 
            'message' => $e->getMessage()
        ]);
    }
    exit;
}
?>

<?php
// Handle DELETE request
if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    try {
        // Hapus semua data
        $stmt = $pdo->prepare("DELETE FROM geofence");
        $stmt->execute();

        // Kirim response sukses
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'success',
            'message' => 'Data berhasil dihapus'
        ]);

    } catch (Exception $e) {
        // Handle error
        header('HTTP/1.1 400 Bad Request');
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => $e->getMessage()
        ]);
    }
    exit;
}
?>