<?php
// Konfigurasi database
$host = 'localhost';
$dbname = 'iotprojectweb_geofence_db';
$username = 'iotprojectweb_admin';
$password = '@Geofence';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    die("Koneksi gagal: " . $e->getMessage());
}

// Handle POST request untuk menyimpan data geofence
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction();

        // Hapus semua data lama di tabel geofence
        $stmtDelete = $pdo->prepare("DELETE FROM geofence");
        $stmtDelete->execute();

        // Ambil data JSON dari request
        $data = json_decode(file_get_contents('php://input'), true);

        if (!$data) {
            throw new Exception('Data tidak valid');
        }

        $latitude = floatval($data['latitude']);
        $longitude = floatval($data['longitude']);
        $radius = floatval($data['radius']);

        // Validasi data
        if (!is_numeric($latitude) || !is_numeric($longitude) || !is_numeric($radius)) {
            throw new Exception('Input harus berupa angka');
        }

        // Simpan geofence baru ke database
        $stmtInsert = $pdo->prepare("INSERT INTO geofence (latitude, longitude, radius, created_at) VALUES (?, ?, ?, NOW())");
        $stmtInsert->execute([$latitude, $longitude, $radius]);

        // Ambil semua sepeda yang ada di tabel lokasi
        $stmtLokasi = $pdo->query("SELECT id_spd, latitude, longitude FROM lokasi");
        $allBikes = $stmtLokasi->fetchAll();

        // Fungsi untuk menghitung jarak Euclidean
        function euclidean_distance($lat1, $lon1, $lat2, $lon2) {
            $x1 = $lon1 * 111319;
            $y1 = $lat1 * 111319;
            $x2 = $lon2 * 111319;
            $y2 = $lat2 * 111319;
            return sqrt(pow($x2 - $x1, 2) + pow($y2 - $y1, 2));
        }

        // Siapkan statement untuk update status lokasi
        $stmtUpdate = $pdo->prepare("UPDATE lokasi SET status = ? WHERE id_spd = ?");

        // Loop untuk setiap sepeda dan update statusnya
        foreach ($allBikes as $bike) {
            $bikeLat = floatval($bike['latitude']);
            $bikeLng = floatval($bike['longitude']);
            $idSpd = $bike['id_spd'];

            // Hitung jarak dari geofence
            $distance = euclidean_distance($latitude, $longitude, $bikeLat, $bikeLng);

            // Tentukan status berdasarkan jarak
            $status = ($distance <= $radius) ? "Di Dalam AREA" : "Di Luar AREA!!!";

            // Update status di database
            $stmtUpdate->execute([$status, $idSpd]);
        }

        // Commit transaksi
        $pdo->commit();

        // Kirim response sukses
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'success',
            'message' => 'Geofence diperbarui dan status sepeda diupdate',
            'data' => [
                'latitude' => $latitude,
                'longitude' => $longitude,
                'radius' => $radius
            ]
        ]);

    } catch (Exception $e) {
        // Rollback transaksi jika terjadi error
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }
        
        // Kirim response error
        header('HTTP/1.1 400 Bad Request');
        header('Content-Type: application/json');
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

// Handle GET request untuk mendapatkan geofence terakhir
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $stmt = $pdo->query("SELECT * FROM geofence ORDER BY created_at DESC LIMIT 1");
        $data = $stmt->fetch();

        header('Content-Type: application/json');
        if ($data) {
            $data['latitude'] = floatval($data['latitude']);
            $data['longitude'] = floatval($data['longitude']);
            $data['radius'] = floatval($data['radius']);
            
            echo json_encode([
                'status' => 'success',
                'data' => $data
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'data' => null
            ]);
        }
    } catch (Exception $e) {
        header('HTTP/1.1 400 Bad Request');
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error', 
            'message' => $e->getMessage()
        ]);
    }
    exit;
}

// Handle DELETE request untuk menghapus geofence
if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    try {
        $stmt = $pdo->prepare("DELETE FROM geofence");
        $stmt->execute();

        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'success',
            'message' => 'Data berhasil dihapus'
        ]);

    } catch (Exception $e) {
        header('HTTP/1.1 400 Bad Request');
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => $e->getMessage()
        ]);
    }
    exit;
}
?>
