<?php
header('Content-Type: application/json');

// Konfigurasi koneksi ke database
$host = 'localhost';
$username = 'iotprojectweb_admin'; 
$password = '@Geofence'; 
$database = 'iotprojectweb_geofence_db'; 

// Membuat koneksi ke database
$conn = new mysqli($host, $username, $password, $database);

// Periksa koneksi
if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Koneksi database gagal: ' . $conn->connect_error]));
}

// Query untuk mendapatkan data terbaru untuk setiap sepeda berdasarkan waktu
$query = "SELECT l.id_spd, l.latitude, l.longitude, l.status, l.waktu 
          FROM lokasi l
          INNER JOIN (
              SELECT id_spd, MAX(waktu) AS max_waktu 
              FROM lokasi 
              GROUP BY id_spd
          ) latest ON l.id_spd = latest.id_spd AND l.waktu = latest.max_waktu
          ORDER BY l.id_spd ASC";

$result = $conn->query($query);
$data = [];

if ($result->num_rows > 0) {
    // Log jumlah baris yang ditemukan untuk debugging
    error_log("Jumlah sepeda unik yang ditemukan: " . $result->num_rows);
    
    while ($row = $result->fetch_assoc()) {
        $data[] = [
            'id_spd' => $row['id_spd'],
            'lat' => $row['latitude'],
            'lng' => $row['longitude'],
            'status' => $row['status'],
            'waktu' => $row['waktu']
        ];
    }
    
    // Log data yang akan dikirim untuk debugging
    error_log("Data sepeda: " . json_encode($data));
    
    echo json_encode(['status' => 'success', 'data' => $data]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Data tidak ditemukan']);
}

// Tutup koneksi database
$conn->close();
?>